function hamming_decoded_output_data = hamming_decoding(hamming_coded_input_data,nr_parity_bits,added_number_zeros_hamming)

data_length = length(hamming_coded_input_data);
% The hamming code is repeated in periods with the following data length
data_period_length = 2^nr_parity_bits -1;
% Number of hamming periods
nr_periods = data_length/data_period_length;
% Data output with parity bits removed
data_output_length = data_length - nr_periods*nr_parity_bits;

% Preallocation
hamming_coded_fixed_data = zeros(1,data_length);
hamming_decoded_output_data = zeros(1,data_output_length);

% Data bit counter
m = 1;

for k=1:data_period_length:data_length
    
    % l is determining where the parity bits are located    
    l = 0;
    
    % Pick out the hamming coded period that will be decoded
    current_hamming_data_period = hamming_coded_input_data(k:k+data_period_length-1);
    
    % current parity bit considered
    ii = 0;
    % the position of the error in the hammming period
    error_bit_position = 0;
   
     while ii < nr_parity_bits
    
    % we sum up bits to detect the position of the error 
    % initialized to zero
    current_parity_sum = 0;
    current_parity_position = 2^ii;    
    
    for g = 0:current_parity_position-1;
    % in the same way as before:
    
    % we sum up all the data differently for each parity bit
    % if parity bit position = 1, every alternate data bit is added
    % together, if parity bit position = 2, we sum 2 bits, leave 2 bits,
    % sum 2 bits and so on until the end of the period
    
    % we always start at the parity position
    
    current_parity_sum_tmp = sum(current_hamming_data_period(...
    (current_parity_position+g):2^(ii+1):data_period_length));
    
    %  this is the updated sum
    current_parity_sum = current_parity_sum + current_parity_sum_tmp;

    end
    
    % if the sum is even it is still correct
    % that is why we can determine if there is an error or not
    
        if mod(current_parity_sum,2) == 0
        
        incorrect_current_parity = 0;
        
        else 
        
        incorrect_current_parity = 1;
        
        end
        
         if incorrect_current_parity == 1
             
             % the error bit position is the sum of all incorrect parity bit
             % positions
       
            error_bit_position = error_bit_position + current_parity_position;
        
         end 
         
         % go to the next parity bit
         ii = ii+1;
        
    end
    
    if error_bit_position ~= 0
        
        % if there is an error, we correct it at the right position (inversion)        
        current_hamming_data_period(error_bit_position) =~ current_hamming_data_period(error_bit_position);
    
    end
    
    % save the corrected hamming period
    hamming_coded_fixed_data(k:k+data_period_length-1) = current_hamming_data_period;
    
    % here we remove the parity bits and only pick out the corrected data
    
    for j=1:data_period_length
               
        % parity position
        if j == 2^l
               
        l=l+1;
        
        else
            
        % data bit position
            
        hamming_decoded_output_data(m) = current_hamming_data_period(j);
        
        % count the appended data bits
        m = m+1;
        
        end
        
    end   
      
end

% remove the zeropadding from the data bits
hamming_decoded_output_data = hamming_decoded_output_data(1:end-added_number_zeros_hamming);